/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.JTFTools;
import acmx.export.javax.swing.JMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

public class JMenuBar
extends Component
implements MouseListener {
    public static final int MENU_MARGIN = 8;
    public static final int MENU_HEIGHT = 16;
    public static final int MENU_OFFSET = 13;
    public static final Color MENU_BAR_COLOR = new Color(0xDDDDDD);
    public static final Color MENU_HIGHLIGHT_COLOR = new Color(128);
    public static final Font MENU_FONT = new Font("Dialog", 0, 12);
    private ArrayList<JMenu> menus;

    public JMenuBar() {
        this.setBackground(MENU_BAR_COLOR);
        this.menus = new ArrayList();
        this.setFont(JTFTools.getStandardFont(MENU_FONT));
        this.addMouseListener(this);
    }

    public int getMenuCount() {
        return this.menus.size();
    }

    public JMenu getMenu(int index) {
        return this.menus.get(index);
    }

    public JMenu add(JMenu menu) {
        this.menus.add(menu);
        super.add(menu.getPopupMenu());
        return menu;
    }

    public Dimension getPreferredSize() {
        return new Dimension(1, 16);
    }

    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        int x = 0;
        FontMetrics fm = g.getFontMetrics();
        int nMenus = this.getMenuCount();
        int i = 0;
        while (i < nMenus) {
            JMenu menu = this.getMenu(i);
            String label = menu.getLabel();
            int width = fm.stringWidth(label) + 16;
            g.setColor(this.getForeground());
            g.drawString(label, x + 8, 13);
            x += width;
            ++i;
        }
    }

    public final void mousePressed(MouseEvent e) {
        Graphics g = this.getGraphics();
        int x = 0;
        FontMetrics fm = g.getFontMetrics();
        int nMenus = this.getMenuCount();
        JMenu menu = null;
        int i = 0;
        while (i < nMenus) {
            menu = this.getMenu(i);
            String label = menu.getLabel();
            int width = fm.stringWidth(label) + 16;
            if (e.getX() > x && e.getX() < x + width) break;
            x += width;
            menu = null;
            ++i;
        }
        if (menu != null) {
            menu.getPopupMenu().show(this, x, 17);
        }
    }

    public final void mouseReleased(MouseEvent e) {
    }

    public final void mouseClicked(MouseEvent e) {
    }

    public final void mouseEntered(MouseEvent e) {
    }

    public final void mouseExited(MouseEvent e) {
    }
}

